import { Component, Input } from '@angular/core';
import { RouteService } from '../service/route.service';

/**
 * ヘッダ
 */
@Component({
  selector: 'app-header',
  templateUrl: './header.component.html',
  styleUrl: './header.component.css'
})
export class HeaderComponent {
  //モード(0:タイトルのみ、1:ログアウトあり)
  @Input() mode = 0;

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   */
  constructor(private routeService: RouteService) { }

  /**
   * ログアウト
   */
  onClickLogout(): void {
    this.routeService.navigateTop();
  }
}
