import { Component, Input, OnInit } from '@angular/core';
import { UserInfoModel } from '../../model/user-info.model';
import { DenyListModel } from '../../model/denylist.model';
import { ColDef, GridApi } from 'ag-grid-community';
import { SizeColumnsToFitGridStrategy, SizeColumnsToFitProvidedWidthStrategy, SizeColumnsToContentStrategy } from 'ag-grid-community'
import { DenyListService } from '../../service/deny-list.service';

/**
 * 拒否リスト
 */
@Component({
  selector: 'app-deny-list',
  templateUrl: './deny-list.component.html',
  styleUrl: './deny-list.component.css'
})
export class DenyListComponent implements OnInit {
  @Input() model?: UserInfoModel;

  denyList: DenyListModel[] = [];

  context?: any;
  private gridApi!: GridApi<DenyListModel>;
  rowSelection: "single" | "multiple" = "multiple";

  colDefs: ColDef[] = [
    { headerName: '区間', field: "rideSection", width: 200, checkboxSelection: true, headerCheckboxSelection: true },
    { headerName: '乗車日時', field: "getonDt", width: 130 },
    { headerName: '降車日時', field: "getoffDt", width: 130 },
    { headerName: '請求金額', field: "billingAmount", width: 100 },
    { headerName: 'ステータス', field: "status", width: 100 },
    { field: "id", hide: true }
  ];
  public autoSizeStrategy:
    | SizeColumnsToFitGridStrategy
    | SizeColumnsToFitProvidedWidthStrategy
    | SizeColumnsToContentStrategy = {
      type: "fitGridWidth",
      defaultMinWidth: 100,
      columnLimits: [
        {
          colId: "country",
          minWidth: 900,
        },
      ],
    };

  /**
   * コンストラクタ
   * @param denyListService 拒否リストサービス
   */
  constructor(private denyListService: DenyListService) {
    this.context = {
      componentParent: this
    }
  }

  /**
   * 初期処理
   */
  ngOnInit(): void {
    if (this.model && this.model.customerId) {
      //this.denyList = this.denyListService.getList(this.model.customerId);
      this.denyListService.getList(this.model.customerId).subscribe((ret: DenyListModel[]) => {
        this.denyList = ret;
      });
    }
  }

  /**
   * 拒否リスト削除依頼
   */
  onClickDel(): void {
    const list: DenyListModel[] = this.gridApi.getSelectedRows();

    //拒否リスト削除依頼
    this.denyListService.reqDelete(list);

    //拒否リスト再取得
    if (this.model && this.model.customerId) {
      //this.denyList = this.denyListService.getList(this.model.customerId);
      this.denyListService.getList(this.model.customerId).subscribe((ret: DenyListModel[]) => {
        this.denyList = ret;
      });
    }

    //↓プロトタイプ
    for (const deny of this.denyList) {
      for (const model of list) {
        if (model.id === deny.id) {
          deny.status = "削除依頼済";
          break;
        }
      }
    }
    //↑プロトタイプ

    this.gridApi.setGridOption("rowData", this.denyList);
  }

  onGridReady(params: any): void {
    this.gridApi = params.api;
  }
}
