import { Component, OnInit } from '@angular/core';
import { ColDef, GridApi } from 'ag-grid-community';
import { SizeColumnsToFitGridStrategy, SizeColumnsToFitProvidedWidthStrategy, SizeColumnsToContentStrategy } from 'ag-grid-community'
import { EarningModel } from '../../model/earning.model';
import { CardRendererComponent } from './card-renderer/card-renderer.component';
import { ProcessDatetimeComponent } from './processdatetime/processdatetime.component';
import { EarningDateComponent } from './earning-date/earning-date.component';
import { GetonDatetimeComponent } from './geton-datetime/geton-datetime.component';
import { GetoffDatetimeComponent } from './getoff-datetime/getoff-datetime.component';
import { StatusComponent } from './status/status.component';
import { NgComponent } from './ng/ng.component';
import { DelreqComponent } from './delreq/delreq.component';
import { EarningListService } from '../../service/earning-list.service';

/**
 * 売上情報一覧
 */
@Component({
  selector: 'app-earning-list',
  templateUrl: './earning-list.component.html',
  styleUrl: './earning-list.component.css'
})
export class EarningListComponent implements OnInit {
  earningList?: EarningModel[];

  context?: any;
  private gridApi!: GridApi<EarningModel>;

  colDefs: ColDef[] = [
    { headerName: '利用者名', field: "cutomerName", width: 100 },
    { headerName: 'カード番号', field: "cardNumber", width: 200, cellRenderer: CardRendererComponent },
    { headerName: '請求番号', field: "billingNumber", width: 200 },
    { headerName: '請求額', field: "billingAmount", width: 100 },
    { headerName: '処理日時', field: "processDateTime", width: 300, cellRenderer: ProcessDatetimeComponent },
    { headerName: '売上日', field: "earningDate", width: 200, cellRenderer: EarningDateComponent },
    { headerName: '乗車日時', field: "getonDateTime", width: 300, cellRenderer: GetonDatetimeComponent },
    { headerName: '降車日時', field: "getoffDateTime", width: 300, cellRenderer: GetoffDatetimeComponent },
    { headerName: '乗降明細', field: "getonoffDetail", width: 300 },
    { headerName: '新規', field: "status", width: 30, cellRenderer: StatusComponent },
    { headerName: 'NG', field: "ngFlag", width: 30, cellRenderer: NgComponent },
    { headerName: '削除依頼', field: "delReq", width: 30, cellRenderer: DelreqComponent }
  ];
  public autoSizeStrategy:
    | SizeColumnsToFitGridStrategy
    | SizeColumnsToFitProvidedWidthStrategy
    | SizeColumnsToContentStrategy = {
      type: "fitGridWidth",
      defaultMinWidth: 100,
      columnLimits: [
        {
          colId: "country",
          minWidth: 900,
        },
      ],
    };

  /**
   * コンストラクタ
   * @param earningListService トークン売上サービス
   */
  constructor(private earningListService: EarningListService) {
    this.context = {
      componentParent: this
    }
  }

  /**
   * 初期処理
   */
  ngOnInit(): void {
    //this.earningList = this.earningListService.getList();
    this.earningListService.getList().subscribe((ret: EarningModel[]) => {
      this.earningList = ret;
    });
  }

  onGridReady(params: any): void {
    this.gridApi = params.api;
  }
}
