import { Component, OnInit } from '@angular/core';
import { PassFareModel } from '../../../model/pass-fare.model';
import { FormControl, Validators } from '@angular/forms';
import { Observable } from 'rxjs';

/**
 * 定期運賃マスタメンテ
 */
@Component({
  selector: 'app-pass-fare',
  templateUrl: './pass-fare.component.html',
  styleUrl: './pass-fare.component.css'
})
export class PassFareComponent implements OnInit {
  invalid?: Observable<boolean>;
  formControl = new FormControl<PassFareModel[]>([], Validators.required);

  //事業所一覧
  agencyList?: Map<string, string>;
  //路線一覧
  routeList?: Map<string, string>;
  //使用期間一覧
  useTermList?: Map<string, string>;
  //停留所一覧
  stopList?: Map<string, string>

  //定期運賃情報
  passFareList: PassFareModel[] = [];

  //事業所ID
  agencyId?: string;
  //路線ID
  routeId?: string;
  //使用期間ID
  useTermId?: string;
  //乗車停留所ID
  getonStopId?: string;
  //降車停留所ID
  getoffStopId?: string;
  //運賃
  fare = 0;

  /**
   * 初期処理
   */
  ngOnInit(): void {
    //事業所一覧
    this.agencyList = new Map();
    for (let i = 0; i < 5; i++) {
      const str = String(i + 1);
      this.agencyList.set(str, "事業所" + str);
    }
    this.agencyId = "1";

    this.onChangeAgency();
  }

  /**
   * 事業者選択
   */
  onChangeAgency(): void {
    //路線一覧
    this.routeList = new Map();
    for (let i = 0; i < 5; i++) {
      const str = String(i + 1);
      this.routeList.set(str, "路線" + str);
    }
    this.routeId = "1";
    this.onChangeRoute();

    //使用期間
    this.useTermList = new Map();
    this.useTermList.set("1", "1ヶ月");
    this.useTermList.set("3", "3ヶ月");
    this.useTermList.set("6", "6ヶ月");

    //停留所
    this.stopList = new Map();
    for (let i = 0; i < 5; i++) {
      const str = String(i + 1);
      this.stopList.set(str, "停留所" + str);
    }
  }

  /**
   * 路線選択
   */
  onChangeRoute(): void {
    //停留所
    this.stopList = new Map();
    for (let i = 0; i < 5; i++) {
      const str = String(i + 1);
      this.stopList.set(str, "停留所" + str);
    }

    this.passFareList = [];
    for (let i = 0; i < 10; i++) {
      const model: PassFareModel = new PassFareModel();
      model.id = String(i + 1);
      model.agencyId = this.agencyId;
      model.routeId = this.routeId;
      model.useTermId = "1";
      model.useTermName = "1ヶ月";
      model.routeName = "【◯◯系統】△△行き";
      model.getonStopId = "1";
      model.getonStopName = "テスト乗車停留所";
      model.getoffStopId = "5";
      model.getoffStopName = "テスト降車停留所";
      model.fare = 600;
      this.passFareList.push(model);
    }
  }

  /**
   * 一覧選択
   * @param model 選択情報
   */
  onClickSel(model: PassFareModel): void {
    this.useTermId = model.useTermId;
    this.getonStopId = model.getonStopId;
    this.getoffStopId = model.getoffStopId;
    this.fare = model.fare;
  }

  /**
   * 追加
   */
  onClickAdd(): void {
    const model: PassFareModel = new PassFareModel();
    model.id = String(this.passFareList.length + 1);
    model.agencyId = this.agencyId;
    model.routeId = this.routeId;
    if (typeof this.routeId !== 'undefined') {
      model.routeName = this.routeList?.get(this.routeId);
    }
    model.useTermId = this.useTermId;
    if (typeof this.useTermId !== 'undefined') {
      model.useTermName = this.useTermList?.get(this.useTermId);
    }
    model.getonStopId = this.getonStopId;
    if (typeof this.getonStopId !== 'undefined') {
      model.getonStopName = this.stopList?.get(this.getonStopId);
    }
    model.getoffStopId = this.getoffStopId;
    if (typeof this.getoffStopId !== 'undefined') {
      model.getoffStopName = this.stopList?.get(this.getoffStopId);
    }
    model.fare = this.fare;
    this.passFareList.push(model);
  }

  /**
   * 更新
   */
  onClickUpdate(): void {
    const list = this.formControl.value;
    if (list !== null) {
      const model = list[0];

      for (const passFare of this.passFareList) {
        if (passFare.id === model.id) {
          passFare.useTermId = this.useTermId;
          if (typeof this.useTermId !== 'undefined') {
            passFare.useTermName = this.useTermList?.get(this.useTermId);
          }
          passFare.getonStopId = this.getonStopId;
          if (typeof this.getonStopId !== 'undefined') {
            passFare.getonStopName = this.stopList?.get(this.getonStopId);
          }
          passFare.getoffStopId = this.getoffStopId;
          if (typeof this.getoffStopId !== 'undefined') {
            passFare.getoffStopName = this.stopList?.get(this.getoffStopId);
          }
          passFare.fare = this.fare;
          break;
        }
      }
    }
  }

  /**
   * 削除
   */
  onClickDel(): void {
    const list = this.formControl.value;
    if (list !== null) {
      const model = list[0];

      const newList = [];
      for (const passFare of this.passFareList) {
        if (passFare.id !== model.id) {
          newList.push(passFare);
        }
      }
      this.passFareList = newList;

      this.useTermId = "";
      this.getonStopId = "";
      this.getoffStopId = "";
      this.fare = 0;
    }
  }
}
