import { Component, OnInit } from '@angular/core';
import { RoleModel } from '../../../model/role.model';
import { FormControl, Validators } from '@angular/forms';
import { Observable } from 'rxjs';
import { map } from 'rxjs/operators';

/**
 * 権限マスタ
 */
@Component({
  selector: 'app-role-mst',
  templateUrl: './role-mst.component.html',
  styleUrl: './role-mst.component.css'
})
export class RoleMstComponent implements OnInit {
  invalid?: Observable<boolean>;
  formControl = new FormControl<RoleModel[]>([], Validators.required);

  //権限一覧
  roleList: RoleModel[] = [];

  //権限名
  roleName?: string;
  //事業所担当者
  staffRole = 0;
  //利用者検索
  userRole = 0;
  //定期券検索
  passRole = 0;
  //乗降履歴
  historyRole = 0;
  //拒否リスト
  denyListRole = 0;
  //マスタメンテ
  masterRole = 0;

  /**
   * コンストラクタ
   */
  constructor() {
    this.invalid = this.formControl.valueChanges.pipe(
      map(() => this.formControl.touched && !this.formControl.valid),
    );
  }

  /**
   * 初期化
   */
  ngOnInit(): void {
    this.roleList = [];
    let model: RoleModel = new RoleModel;
    model.roleId = "1";
    model.name = "担当";
    model.staffRole = 0;
    model.userRole = 1;
    model.passRole = 1;
    model.historyRole = 1;
    model.denyListRole = 1;
    model.masterRole = 0;
    this.roleList.push(model);
    model = new RoleModel;
    model.roleId = "2";
    model.name = "事業所管理者";
    model.staffRole = 1;
    model.userRole = 1;
    model.passRole = 1;
    model.historyRole = 1;
    model.denyListRole = 1;
    model.masterRole = 0;
    this.roleList.push(model);
    model = new RoleModel;
    model.roleId = "3";
    model.name = "システム管理者";
    model.staffRole = 2;
    model.userRole = 2;
    model.passRole = 2;
    model.historyRole = 2;
    model.denyListRole = 2;
    model.masterRole = 1;
    this.roleList.push(model);
  }

  /**
   * 追加
   */
  onClickAdd(): void {
    const model: RoleModel = new RoleModel();
    model.roleId = String(this.roleList.length + 1);
    model.name = this.roleName;
    model.staffRole = this.staffRole;
    model.userRole = this.userRole;
    model.passRole = this.passRole;
    model.historyRole = this.historyRole;
    model.denyListRole = this.denyListRole;
    model.masterRole = this.masterRole;
    this.roleList.push(model);
  }

  /**
   * 更新
   */
  onClickUpdate(): void {
    const list = this.formControl.value;
    if (list !== null) {
      const model = list[0];

      for (const role of this.roleList) {
        if (role.roleId === model.roleId) {
          role.name = this.roleName;
          role.staffRole = this.staffRole;
          role.userRole = this.userRole;
          role.passRole = this.passRole;
          role.historyRole = this.historyRole;
          role.denyListRole = this.denyListRole;
          role.masterRole = this.masterRole;
          break;
        }
      }
    }
  }

  /**
   * 削除
   */
  onClickDel(): void {
    const list = this.formControl.value;
    if (list !== null) {
      const model = list[0];

      const newList = [];
      for (const role of this.roleList) {
        if (role.roleId !== model.roleId) {
          newList.push(role);
        }
      }
      this.roleList = newList;

      this.roleName = "";
      this.staffRole = 0;
      this.userRole = 0;
      this.passRole = 0;
      this.historyRole = 0;
      this.denyListRole = 0;
      this.masterRole = 0;
    }
  }

  /**
   * 選択
   * @param model 権限情報
   */
  onClickSel(model: RoleModel): void {
    this.roleName = model.name;
    this.staffRole = model.staffRole;
    this.userRole = model.userRole;
    this.passRole = model.passRole;
    this.historyRole = model.historyRole;
    this.denyListRole = model.denyListRole;
    this.masterRole = model.masterRole;
  }
}
