import { ICellRendererAngularComp } from 'ag-grid-angular';
import { ICellRendererParams } from 'ag-grid-community';
import { Component } from '@angular/core';

/**
 * 払戻ボタン
 */
@Component({
  selector: 'app-refund-button',
  templateUrl: './refund-button.component.html',
  styleUrl: './refund-button.component.css'
})
export class RefundButtonComponent implements ICellRendererAngularComp {
  //パラメータ
  params: any;
  //親コンポーネント
  componentParent: any;

  /**
   * 初期処理
   * @param params パラメータ
   */
  agInit(params: ICellRendererParams): void {
    console.log(params);
    this.params = params;
    this.componentParent = this.params.context.componentParent;
  }

  /**
   * リフレッシュ
   * @param params パラメータ 
   * @returns 正常かどうか
   */
  refresh(params: ICellRendererParams): boolean {
    return true;
  }

  /**
   * ボタンクリック
   */
  onClickRefund(): void {
    this.componentParent.onClickRefund(this.params.data);
  }
}
