import { ICellRendererAngularComp } from 'ag-grid-angular';
import { ICellRendererParams } from 'ag-grid-community';
import { Component } from '@angular/core';

/**
 * 乗車履歴ボタン
 */
@Component({
  selector: 'app-history-button',
  templateUrl: './history-button.component.html',
  styleUrl: './history-button.component.css'
})
export class HistoryButtonComponent implements ICellRendererAngularComp {
  //パラメータ
  params: any;
  //親コンポーネント
  componentParent: any;

  /**
   * 初期処理
   * @param params パラメータ
   */
  agInit(params: ICellRendererParams): void {
    console.log(params);
    this.params = params;
    this.componentParent = this.params.context.componentParent;
  }

  /**
   * リフレッシュ
   * @param params パラメータ 
   * @returns 正常かどうか
   */
  refresh(params: ICellRendererParams): boolean {
    return true;
  }

  /**
   * ボタンクリック
   */
  onClickHistory(): void {
    this.componentParent.onClickHistory(this.params.data);
  }
}
