import { ICellRendererAngularComp } from 'ag-grid-angular';
import { ICellRendererParams } from 'ag-grid-community';
import { Component } from '@angular/core';

/**
 * 定期券ボタン
 */
@Component({
  selector: 'app-pass-button',
  templateUrl: './pass-button.component.html',
  styleUrl: './pass-button.component.css'
})
export class PassButtonComponent implements ICellRendererAngularComp {
  //パラメータ
  params: any;
  //親コンポーネント
  componentParent: any;

  /**
   * 初期処理
   * @param params パラメータ
   */
  agInit(params: ICellRendererParams): void {
    console.log(params);
    this.params = params;
    this.componentParent = this.params.context.componentParent;
  }

  /**
   * リフレッシュ
   * @param params パラメータ 
   * @returns 正常かどうか
   */
  refresh(params: ICellRendererParams): boolean {
    return true;
  }

  /**
   * ボタンクリック
   */
  onClickPass(): void {
    this.componentParent.onClickPass(this.params.data);
  }
}
