import { Injectable } from '@angular/core';
import { DenyListModel } from '../model/denylist.model';
import { Observable } from 'rxjs';

/**
 * 拒否リストサービス
 */
@Injectable({
  providedIn: 'root'
})
export class DenyListService {
  /**
   * 拒否リスト取得
   * @param customerId 利用者ID
   * @returns 拒否リスト
   */
  getList(customerId: string): Observable<DenyListModel[]> {
    //TODO
    const denyList: DenyListModel[] = [];
    if (customerId) {
      for (let i = 0; i < 5; i++) {
        const model: DenyListModel = new DenyListModel();
        const str = String(i + 1);
        model.id = str;
        model.rideSection = "A停留所→B停留所";
        model.getonDt = "2024/07/01 10:10:10";
        model.getoffDt = "2024/07/01 10:20:20";
        model.billingAmount = 100;
        model.status = "";
        denyList.push(model);
      }
    }
    //return denyList;
    return new Observable<DenyListModel[]>(o => {
      o.next(denyList);
    });
  }

  /**
   * 拒否リスト削除依頼
   * @param list 選択拒否リスト
   */
  reqDelete(list: DenyListModel[]): void {
    //TODO
    if (list) {
      return;
    }
  }
}
