import { Injectable } from '@angular/core';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { PassRefundComponent } from '../menu/pass-list/pass-refund/pass-refund.component';
import { PassModel } from '../model/pass.model';

/**
 * 定期券払戻サービス
 */
@Injectable({
  providedIn: 'root'
})
export class PassRefundService {
  /**
   * コンストラクタ
   * @param modalService 
   */
  constructor(private modalService: NgbModal) { }

  /**
   * ボタン押下
   * @returns OK(true)/NO(false)
   */
  confirm(model: PassModel): Promise<boolean> {
    const modalRef = this.modalService.open(PassRefundComponent);
    const component = modalRef.componentInstance as PassRefundComponent;
    if (component != null) {
      component.model = model;
    }
    return modalRef.result.then(() => {
      return true;
    }, () => {
      return false;
    });
  }
}
