import { Injectable } from '@angular/core';
import { StaffInfoModel } from '../model/staff-info.model';
import { Observable } from 'rxjs';

/**
 * 担当者サービス
 */
@Injectable({
  providedIn: 'root'
})
export class StaffService {
  /**
   * 担当者一覧取得
   * @param agencyId 事業者ID
   * @returns 担当者情報一覧
   */
  getList(agencyId?: string): Observable<StaffInfoModel[]> {
    //TODO
    const staffList: StaffInfoModel[] = [];
    if (agencyId) {
      for (let i = 0; i < 5; i++) {
        const model = new StaffInfoModel();
        model.agencyId = String(i + 1);
        model.email = "test" + String(i + 1) + "@test.com";
        model.name = "山田 太郎";
        model.password = "00000000";
        model.company = "テスト会社";
        model.department = "テスト部";
        model.roleId = "1";
        model.roleName = "システム管理者";
        staffList.push(model);
      }
    }
    //return staffList;
    return new Observable<StaffInfoModel[]>(o => {
      o.next(staffList);
    });
  }

  /**
   * 事業者一覧取得
   * @returns 事業者一覧
   */
  getAgencyList(): Observable<Map<string, string>> {
    //TODO
    const agencyList = new Map();
    for (let i = 0; i < 5; i++) {
      const str = String(i + 1);
      agencyList.set("000" + str, "事業所" + str);
    }
    //return agencyList;
    return new Observable<Map<string, string>>(o => {
      o.next(agencyList);
    });
  }

  /**
   * 権限一覧取得
   * @returns 権限一覧
   */
  getRoleList(): Observable<Map<string, string>> {
    //TODO
    const roleList = new Map();
    for (let i = 0; i < 3; i++) {
      const str = String(i + 1);
      roleList?.set(str, "権限" + str)
    }

    //return roleList;
    return new Observable<Map<string, string>>(o => {
      o.next(roleList);
    });
  }

  /**
   * 担当者登録
   * @param model 担当者情報
   */
  regist(model: StaffInfoModel): void {
    //TODO
    if (model) {
      return;
    }
  }

  /**
   * 担当者更新
   * @param model 担当者情報
   */
  update(model: StaffInfoModel): void {
    //TODO
    if (model) {
      return;
    }
  }

  /**
   * 担当者情報削除
   * @param emailList メールアドレス
   */
  delete(emailList: string[]): void {
    //TODO
    if (emailList) {
      return;
    }
  }
}
