import { Injectable } from '@angular/core';
import { StatusUpdateComponent } from '../menu/history-list/status-update/status-update.component';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { HistoryModel } from '../model/history.model';

/**
 * ステータス更新サービス
 */
@Injectable({
  providedIn: 'root'
})
export class StatusUpdateService {
  //乗降履歴
  model?: HistoryModel;

  /**
   * コンストラクタ
   * @param modalService モーダル
   */
  constructor(private modalService: NgbModal) { }

  /**
   * ボタン押下
   * @param model 乗降履歴
   * @returns OK(true)/NO(false)
   */
  confirm(model: HistoryModel): Promise<boolean> {
    this.model = model;
    const modalRef = this.modalService.open(StatusUpdateComponent);
    const component = modalRef.componentInstance as StatusUpdateComponent;
    component.model = model;
    component.status = model.status;
    return modalRef.result.then(() => {
      return true;
    }, () => {
      return false;
    });
  }
}
