import { Component, OnInit } from '@angular/core';
import { RouteService } from '../service/route.service';
import { LoginService } from '../service/login.service';
import { RoleModel } from '../model/role.model';
import $ from 'jquery';

/**
 * ログイン画面
 */
@Component({
  selector: 'app-top',
  templateUrl: './top.component.html',
  styleUrl: './top.component.css'
})
export class TopComponent implements OnInit {
  //メールアドレス
  email?: string;
  //パスワード
  password?: string;

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   * @param loginService ログインサービス
   */
  constructor(private routeService: RouteService, private loginService: LoginService) { }

  ngOnInit(): void {
    $("#email").focus();
  }

  /**
   * ログイン
   */
  onClickLogin(): void {
    if (!this.loginService.login(this.email, this.password)) {
      return;
    }
    const agencyId = "0001";
    const role = new RoleModel();
    role.roleId = "1";
    role.staffRole = 2;
    role.userRole = 2;
    role.passRole = 2;
    role.historyRole = 2;
    role.denyListRole = 2;
    role.earningList = 2;
    role.masterRole = 2;
    this.routeService.navigateMenu(agencyId, role);
  }
}
