import { Injectable } from '@angular/core';
import { HistoryModel } from '../model/history.model';

/**
 * 乗降履歴サービス
 */
@Injectable({
  providedIn: 'root'
})
export class HistoryService {
  /**
   * 乗降一覧取得
   * @param customerId 利用者ID
   * @returns 乗降一覧
   */
  getList(customerId: string): HistoryModel[] {
    //TODO
    const historyList: HistoryModel[] = [];
    if (customerId) {
      for (let i = 0; i < 10; i++) {
        const model: HistoryModel = new HistoryModel();
        model.getonoffDate = "2024/07/01 17:10:10";
        if (i % 2 === 0) {
          model.getonoff = "乗車";
          model.stopName = "A停留所";
        } else {
          model.getonoff = "降車";
          model.stopName = "B停留所";
        }
        model.payment = 100;
        model.statusId = "";
        model.status = "";
        historyList.push(model);
      }
      const model: HistoryModel = new HistoryModel();
      model.getonoffDate = "2024/07/01 17:01:01";
      model.getonoff = "乗車";
      model.stopName = "A停留所";
      model.payment = 100;
      model.statusId = "0";
      model.status = "乗車中";
      historyList.push(model);
    }

    return historyList;
  }

  /**
   * 乗降ステータス変更
   * @param model 乗降履歴情報
   */
  changeStatus(model: HistoryModel): void {
    //TODO
    if (model) {
      return;
    }
  }
}
