import { ICellRendererAngularComp } from 'ag-grid-angular';
import { ICellRendererParams } from 'ag-grid-community';
import { Component } from '@angular/core';

/**
 * ボタンレンダリング
 */
@Component({
  selector: 'app-custom-button',
  templateUrl: './custom-button.component.html',
  styleUrl: './custom-button.component.css'
})
export class CustomButtonComponent implements ICellRendererAngularComp {
  //パラメータ
  params: any;
  //親コンポーネント
  componentParent: any;

  /**
   * 初期処理
   * @param params パラメータ
   */
  agInit(params: ICellRendererParams): void {
    console.log(params);
    this.params = params;
    this.componentParent = this.params.context.componentParent;
  }

  /**
   * リフレッシュ
   * @param params パラメータ 
   * @returns 正常かどうか
   */
  refresh(params: ICellRendererParams) {
    return true;
  }

  /**
   * ボタンクリック
   */
  onClickEdit(): void {
    this.componentParent.onClickEdit(this.params.data);
  }
}
