import { ICellRendererAngularComp } from 'ag-grid-angular';
import { ICellRendererParams } from 'ag-grid-community';
import { Component } from '@angular/core';

/**
 * 拒否リストボタン
 */
@Component({
  selector: 'app-denylist-button',
  templateUrl: './denylist-button.component.html',
  styleUrl: './denylist-button.component.css'
})
export class DenylistButtonComponent implements ICellRendererAngularComp {
  //パラメータ
  params: any;
  //親コンポーネント
  componentParent: any;

  /**
   * 初期処理
   * @param params パラメータ
   */
  agInit(params: ICellRendererParams): void {
    console.log(params);
    this.params = params;
    this.componentParent = this.params.context.componentParent;
  }

  /**
   * リフレッシュ
   * @param params パラメータ 
   * @returns 正常かどうか
   */
  refresh(params: ICellRendererParams) {
    return true;
  }


  /**
   * ボタンクリック
   */
  onClickDenyList(): void {
    this.componentParent.onClickDenyList(this.params.data);
  }
}
