import { Injectable } from '@angular/core';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { PassRefundComponent } from '../menu/pass-list/pass-refund/pass-refund.component';

/**
 * 定期券払戻サービス
 */
@Injectable({
  providedIn: 'root'
})
export class PassRefundService {
  /**
   * コンストラクタ
   * @param modalService 
   */
  constructor(private modalService: NgbModal) { }

  /**
   * ボタン押下
   * @returns OK(true)/NO(false)
   */
  confirm(): Promise<boolean> {
    const modalRef = this.modalService.open(PassRefundComponent);
    return modalRef.result.then(() => {
      return true;
    }, () => {
      return false;
    });
  }
}
