import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { UserInfoModel } from '../../model/user-info.model';
import { ColDef, GridApi } from 'ag-grid-community';
import { HistoryButtonComponent } from './history-button/history-button.component';
import { DenylistButtonComponent } from './denylist-button/denylist-button.component';
import { SizeColumnsToFitGridStrategy, SizeColumnsToFitProvidedWidthStrategy, SizeColumnsToContentStrategy } from 'ag-grid-community'
import { PassButtonComponent } from './pass-button/pass-button.component';
import { UserService } from '../../service/user.service';
import { RoleModel } from '../../model/role.model';
import $ from 'jquery';

/**
 * 利用者検索画面
 */
@Component({
  selector: 'app-user-list',
  templateUrl: './user-list.component.html',
  styleUrl: './user-list.component.css'
})
export class UserListComponent implements OnInit {
  @Input() role?: RoleModel;
  @Output() clickPass: EventEmitter<UserInfoModel> = new EventEmitter<UserInfoModel>();
  @Output() clickHistory: EventEmitter<UserInfoModel> = new EventEmitter<UserInfoModel>();
  @Output() clickDenyList: EventEmitter<UserInfoModel> = new EventEmitter<UserInfoModel>();

  //利用者名
  userName?: string;
  //利用者一覧
  userList: UserInfoModel[] = [];

  context: any;
  private gridApi!: GridApi<UserInfoModel>;

  colDefs: ColDef[] = [
    { headerName: '氏名', field: "name", width: 200 },
    { headerName: 'フリガナ', field: "nameKana", width: 200 },
    { headerName: 'メールアドレス', field: "email", width: 200 },
    { headerName: '電話番号', field: "phoneNumber", width: 200 },
    { headerName: '', field: "pass", width: 80, cellRenderer: PassButtonComponent, cellRendererParams: { role: this.role } },
    { headerName: '', field: "history", width: 80, cellRenderer: HistoryButtonComponent, cellRendererParams: { role: this.role } },
    { headerName: '', field: "denyList", width: 80, cellRenderer: DenylistButtonComponent, cellRendererParams: { role: this.role } },
  ];
  public autoSizeStrategy:
    | SizeColumnsToFitGridStrategy
    | SizeColumnsToFitProvidedWidthStrategy
    | SizeColumnsToContentStrategy = {
      type: "fitGridWidth",
      defaultMinWidth: 100,
      columnLimits: [
        {
          colId: "country",
          minWidth: 900,
        },
      ],
    };


  /**
   * コンストラクタ
   * @param userService 利用者サービス
   */
  constructor(private userService: UserService) {
    this.context = {
      componentParent: this
    }
  }

  /**
   * 初期処理
   */
  ngOnInit(): void {
    $("#userName").focus();
  }

  /**
   * 検索
   */
  onClickSearch(): void {
    this.userList = this.userService.getList(this.userName);
  }

  onGridReady(params: any): void {
    this.gridApi = params.api;
  }

  /**
   * 定期券クリック
   * @param model 利用者情報
   */
  onClickPass(model: UserInfoModel): void {
    this.clickPass.emit(model);
  }

  /**
   * 乗車履歴クリック
   * @param model  利用者情報
   */
  onClickHistory(model: UserInfoModel): void {
    this.clickHistory.emit(model);
  }

  /**
   * 拒否リストクリック
   * @param model 利用者情報
   */
  onClickDenyList(model: UserInfoModel): void {
    this.clickDenyList.emit(model);
  }
}
