import { NgModule } from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { AppRoutingModule } from './app-routing.module';
import { AppComponent } from './app.component';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { jqxGridModule } from 'jqwidgets-ng/jqxgrid';
import { CommonModule } from '@angular/common';
import { CdkListbox, CdkOption } from '@angular/cdk/listbox';
import { AgGridAngular } from 'ag-grid-angular';

import { TopComponent } from './top/top.component';
import { HeaderComponent } from './header/header.component';
import { MenuComponent } from './menu/menu.component';
import { provideAnimationsAsync } from '@angular/platform-browser/animations/async';
import { StaffListComponent } from './menu/staff-list/staff-list.component';
import { UserListComponent } from './menu/user-list/user-list.component';
import { RoleMstComponent } from './menu/master/role-mst/role-mst.component';
import { PassFareComponent } from './menu/master/pass-fare/pass-fare.component';
import { StaffRegistComponent } from './menu/staff-regist/staff-regist.component';
import { CustomButtonComponent } from './menu/staff-list/custom-button/custom-button.component';
import { PassButtonComponent } from './menu/user-list/pass-button/pass-button.component';
import { HistoryButtonComponent } from './menu/user-list/history-button/history-button.component';
import { DenylistButtonComponent } from './menu/user-list/denylist-button/denylist-button.component';
import { PassListComponent } from './menu/pass-list/pass-list.component';
import { RefundButtonComponent } from './menu/pass-list/refund-button/refund-button.component';
import { PassRefundComponent } from './menu/pass-list/pass-refund/pass-refund.component';
import { HistoryListComponent } from './menu/history-list/history-list.component';
import { StatusLinkComponent } from './menu/history-list/status-link/status-link.component';
import { StatusUpdateComponent } from './menu/history-list/status-update/status-update.component';
import { DenyListComponent } from './menu/deny-list/deny-list.component';
import { EarningListComponent } from './menu/earning-list/earning-list.component';
import { CardRendererComponent } from './menu/earning-list/card-renderer/card-renderer.component';
import { ProcessDatetimeComponent } from './menu/earning-list/processdatetime/processdatetime.component';
import { EarningDateComponent } from './menu/earning-list/earning-date/earning-date.component';
import { GetonDatetimeComponent } from './menu/earning-list/geton-datetime/geton-datetime.component';
import { GetoffDatetimeComponent } from './menu/earning-list/getoff-datetime/getoff-datetime.component';
import { StatusComponent } from './menu/earning-list/status/status.component';
import { NgComponent } from './menu/earning-list/ng/ng.component';
import { DelreqComponent } from './menu/earning-list/delreq/delreq.component';

@NgModule({
  declarations: [
    AppComponent,
    TopComponent,
    HeaderComponent,
    MenuComponent,
    StaffListComponent,
    UserListComponent,
    RoleMstComponent,
    PassFareComponent,
    StaffRegistComponent,
    CustomButtonComponent,
    PassButtonComponent,
    HistoryButtonComponent,
    DenylistButtonComponent,
    PassListComponent,
    RefundButtonComponent,
    PassRefundComponent,
    HistoryListComponent,
    StatusLinkComponent,
    StatusUpdateComponent,
    DenyListComponent,
    EarningListComponent,
    CardRendererComponent,
    ProcessDatetimeComponent,
    EarningDateComponent,
    GetonDatetimeComponent,
    GetoffDatetimeComponent,
    StatusComponent,
    NgComponent,
    DelreqComponent
  ],
  imports: [
    BrowserModule,
    AppRoutingModule,
    NgbModule,
    FormsModule,
    jqxGridModule,
    CommonModule,
    CdkListbox,
    CdkOption,
    ReactiveFormsModule,
    AgGridAngular
  ],
  providers: [
    provideAnimationsAsync()
  ],
  bootstrap: [AppComponent]
})
export class AppModule { }
