import { Component, Input, OnInit } from '@angular/core';
import { HistoryModel } from '../../model/history.model';
import { UserInfoModel } from '../../model/user-info.model';
import { ColDef, GridApi } from 'ag-grid-community';
import { SizeColumnsToFitGridStrategy, SizeColumnsToFitProvidedWidthStrategy, SizeColumnsToContentStrategy } from 'ag-grid-community'
import { StatusLinkComponent } from './status-link/status-link.component';
import { StatusUpdateService } from '../../service/status-update.service';
import { HistoryService } from '../../service/history.service';

/**
 * 乗降履歴
 */
@Component({
  selector: 'app-history-list',
  templateUrl: './history-list.component.html',
  styleUrl: './history-list.component.css'
})
export class HistoryListComponent implements OnInit {
  //利用者情報
  @Input() model?: UserInfoModel;

  historyList: HistoryModel[] = [];

  context?: any;
  private gridApi!: GridApi<HistoryModel>;

  colDefs: ColDef[] = [
    { headerName: '乗降日時', field: "getonoffDate", width: 400 },
    { headerName: '', field: "getonoff", width: 100 },
    { headerName: '乗降停留所', field: "stopName", width: 100 },
    { headerName: '支払金額', field: "payment", width: 100 },
    { headerName: 'ステータス', field: "status", width: 80, cellRenderer: StatusLinkComponent },
  ];
  public autoSizeStrategy:
    | SizeColumnsToFitGridStrategy
    | SizeColumnsToFitProvidedWidthStrategy
    | SizeColumnsToContentStrategy = {
      type: "fitGridWidth",
      defaultMinWidth: 100,
      columnLimits: [
        {
          colId: "country",
          minWidth: 900,
        },
      ],
    };

  /**
   * コンストラクタ
   * @param statusUpdateService ステータス更新サービス
   * @param historyService 乗降履歴サービス
   */
  constructor(private statusUpdateService: StatusUpdateService, private historyService: HistoryService) {
    this.context = {
      componentParent: this
    }
  }

  /**
   * 初期処理
   */
  ngOnInit(): void {
    if (this.model && this.model.customerId) {
      //this.historyList = this.historyService.getList(this.model.customerId);
      this.historyService.getList(this.model.customerId).subscribe((ret: HistoryModel[]) => {
        this.historyList = ret;
      });
    }
  }

  /**
   * ステータスクリック
   * @param model 乗車履歴情報
   */
  onClickStatus(model: HistoryModel) {
    if ((this.statusUpdateService.confirm(model)).valueOf()) {
      this.historyService.changeStatus(model);
    }

  }

  onGridReady(params: any): void {
    this.gridApi = params.api;
  }
}
