import { Component } from '@angular/core';
import { PassModel } from '../../../model/pass.model';
import { NgbActiveModal } from '@ng-bootstrap/ng-bootstrap';

/**
 * 払戻ダイアログ
 */
@Component({
  selector: 'app-pass-refund',
  templateUrl: './pass-refund.component.html',
  styleUrl: './pass-refund.component.css'
})
export class PassRefundComponent {
  //定期情報
  model?: PassModel;

  //購入金額
  purphaseAmount = 0;
  //通常運賃
  standardFare = 0;
  //使用日
  useDays = 0;
  //払戻手数料
  refundFee = 0;
  //払戻額
  refundAmount = 0;

  /**
   * コンストラクタ
   * @param activeModal モーダル
   */
  constructor(private activeModal: NgbActiveModal) { }

  /**
   * 払戻
   */
  onClickRefund(): void {
    if (confirm("選択されているクレジットカードで払い戻ししてよろしいですか？")) {
      this.activeModal.close();
    }
  }

  /**
   * 閉じる
   */
  onClickClose(): void {
    this.activeModal.dismiss();
  }
}
