import { Injectable } from '@angular/core';
import { Router } from '@angular/router';
import { RoleModel } from '../model/role.model';

/**
 * 画面遷移サービス
 */
@Injectable({
  providedIn: 'root'
})
export class RouteService {
  //事業者ID
  agencyId?: string;
  //権限ID
  role?: RoleModel;

  /**
   * コンストラクタ
   * @param router ルーター
   */
  constructor(private router: Router) { }

  /**
   * ログイン画面へ遷移
   */
  navigateTop(): void {
    this.router.navigate(['top'])
  }

  /**
   * メニューへ遷移
   * @param agencyId 事業者ID
   * @param role 権限情報
   */
  navigateMenu(agencyId?: string, role?: RoleModel): void {
    this.agencyId = agencyId;
    this.role = role;
    this.router.navigate(['menu'])
  }
}
