import { Component } from '@angular/core';
import { ICellRendererParams } from 'ag-grid-community';

@Component({
  selector: 'app-earning-date',
  templateUrl: './earning-date.component.html',
  styleUrl: './earning-date.component.css'
})
export class EarningDateComponent {
  //パラメータ
  params: any;

  year?: string;
  month?: string;
  day?: string;

  /**
   * 初期処理
   * @param params パラメータ
   */
  agInit(params: ICellRendererParams): void {
    console.log(params);
    this.params = params;
    if (params.data.processDateTime) {
      const dt: string = params.data.processDateTime;
      this.year = dt.substring(0, 4);
      this.month = dt.substring(4, 6);
      this.day = dt.substring(6, 8);
    }
  }

  /**
   * リフレッシュ
   * @param params パラメータ 
   * @returns 正常かどうか
   */
  refresh(params: ICellRendererParams) {
    return true;
  }
}
