import { Component, Input, OnInit } from '@angular/core';
import { PassModel } from '../../model/pass.model';
import { ColDef, GridApi } from 'ag-grid-community';
import { SizeColumnsToFitGridStrategy, SizeColumnsToFitProvidedWidthStrategy, SizeColumnsToContentStrategy } from 'ag-grid-community'
import { RefundButtonComponent } from './refund-button/refund-button.component';
import { UserInfoModel } from '../../model/user-info.model';
import { PassRefundService } from '../../service/pass-refund.service';
import { PassService } from '../../service/pass.service';

@Component({
  selector: 'app-pass-list',
  templateUrl: './pass-list.component.html',
  styleUrl: './pass-list.component.css'
})
export class PassListComponent implements OnInit {
  //利用者情報
  @Input() model?: UserInfoModel;

  //定期券一覧
  passList: PassModel[] = [];

  context?: any;
  private gridApi!: GridApi<PassModel>;

  colDefs: ColDef[] = [
    { headerName: '路線', field: "routeName", width: 400 },
    { headerName: '使用開始日', field: "startDate", width: 100 },
    { headerName: '使用期間', field: "useTerm", width: 100 },
    { headerName: '料金区分', field: "priceRange", width: 100 },
    { headerName: '乗車区間', field: "rideSection", width: 150 },
    { headerName: 'カード番号', field: "creditCardNumber", width: 150 },
    { headerName: '', field: "refund", width: 80, cellRenderer: RefundButtonComponent },
  ];
  public autoSizeStrategy:
    | SizeColumnsToFitGridStrategy
    | SizeColumnsToFitProvidedWidthStrategy
    | SizeColumnsToContentStrategy = {
      type: "fitGridWidth",
      defaultMinWidth: 100,
      columnLimits: [
        {
          colId: "country",
          minWidth: 900,
        },
      ],
    };

  /**
   * コンストラクタ
   * @param passRefundService 
   * @param passService 
   */
  constructor(private passRefundService: PassRefundService, private passService: PassService) {
    this.context = {
      componentParent: this
    }
  }

  /**
   * 初期処理
   */
  ngOnInit(): void {
    if (this.model && this.model.customerId) {
      this.passList = this.passService.getList(this.model.customerId);
    }
  }

  /**
   * 払い戻し
   * @param model 定期券情報
   */
  async onClickRefund(model: PassModel) {
    if (await this.passRefundService.confirm().valueOf()) {
      //払戻処理
      this.passService.refund(model);
    }

  }

  onGridReady(params: any): void {
    this.gridApi = params.api;
  }
}
