import { Component } from '@angular/core';
import { PassModel } from '../../../model/pass.model';
import { NgbActiveModal } from '@ng-bootstrap/ng-bootstrap';

@Component({
  selector: 'app-pass-refund',
  templateUrl: './pass-refund.component.html',
  styleUrl: './pass-refund.component.css'
})
export class PassRefundComponent {
  model?: PassModel;
  purphaseAmount = 0;
  standardFare = 0;
  useDays = 0;
  refundFee = 0;
  refundAmount = 0;

  constructor(private activeModal: NgbActiveModal) { }

  /**
   * 払戻
   */
  onClickRefund(): void {
    if (confirm("選択されているクレジットカードで払い戻ししてよろしいですか？")) {
      this.activeModal.close();
    }
  }

  /**
   * 閉じる
   */
  onClickClose(): void {
    this.activeModal.dismiss();
  }
}
