import { Component } from '@angular/core';
import { RouteService } from '../service/route.service';
import { LoginService } from '../service/login.service';

/**
 * ログイン画面
 */
@Component({
  selector: 'app-top',
  templateUrl: './top.component.html',
  styleUrl: './top.component.css'
})
export class TopComponent {
  //メールアドレス
  email?: string;
  //パスワード
  password?: string;

  /**
   * コンストラクタ
   */
  constructor(private routeService: RouteService, private loginService: LoginService) { }

  /**
   * ログイン
   */
  onClickLogin(): void {
    if (!this.loginService.login(this.email, this.password)) {
      return;
    }
    this.routeService.navigateMenu();
  }
}
