import { Component } from '@angular/core';
import { StaffInfoModel } from '../model/staff-info.model';
import { PassModel } from '../model/pass.model';
import { UserInfoModel } from '../model/user-info.model';

@Component({
  selector: 'app-menu',
  templateUrl: './menu.component.html',
  styleUrl: './menu.component.css'
})
export class MenuComponent {
  //モード(1:事業所担当者、2:利用者検索、21:利用者登録・更新、3:権限マスタ、4:定期券運賃マスタ)
  mode = 1;

  //担当者編集モード(0:登録、1:編集)
  staffEditMode = 0;

  //担当者情報
  staffInfoModel?: StaffInfoModel;

  //利用者情報
  userInfoModel?: UserInfoModel;

  //定期券情報
  passModel?: PassModel;

  /**
   * 事業所担当者
   */
  onClickBusiness(): void {
    this.mode = 1;
  }

  /**
   * 新規
   */
  onClickNew(): void {
    this.mode = 11;
    this.staffEditMode = 0;
  }

  /**
   * 編集
   * @param row 行番号
   */
  onClickEdit(data: StaffInfoModel): void {
    this.mode = 11;
    this.staffEditMode = 1;
    this.staffInfoModel = data;
  }

  /**
   * 担当者登録後
   */
  onClickRegist(): void {
    this.mode = 1;
  }

  /**
   * 利用者検索
   */
  onClickUser(): void {
    this.mode = 2;
  }

  /**
 * 定期券クリック
 * @param model 利用者情報
 */
  onClickPass(model: UserInfoModel): void {
    this.mode = 21;
    this.userInfoModel = model;
  }

  /**
   * 乗車履歴クリック
   * @param model 利用者情報
   */
  onClickHistory(model: UserInfoModel): void {
    this.mode = 22;
    this.userInfoModel = model;
  }

  /**
   * 拒否リストクリック
   * @param model 利用者情報
   */
  onClickDenyList(model: UserInfoModel): void {
    this.mode = 23;
    this.userInfoModel = model;
  }

  /**
   * 権限マスタ
   */
  onClickRoleMst(): void {
    this.mode = 3;
  }

  /**
   * 定期券運賃マスタ
   */
  onClickPassFare(): void {
    this.mode = 4;
  }

  /**
   * 売上一覧
   */
  onClickEarning(): void {
    this.mode = 5;
  }

}
