import { Component, EventEmitter, OnInit, Output } from '@angular/core';
import { StaffInfoModel } from '../../model/staff-info.model';
import { CustomButtonComponent } from './custom-button/custom-button.component';
import { ColDef, GridApi } from 'ag-grid-community';
import { SizeColumnsToFitGridStrategy, SizeColumnsToFitProvidedWidthStrategy, SizeColumnsToContentStrategy } from 'ag-grid-community'

/**
 * 事業所担当者一覧
 */
@Component({
  selector: 'app-staff-list',
  templateUrl: './staff-list.component.html',
  styleUrl: './staff-list.component.css'
})
export class StaffListComponent implements OnInit {
  @Output() clickNew: EventEmitter<void> = new EventEmitter<void>();
  @Output() clickEdit: EventEmitter<StaffInfoModel> = new EventEmitter<StaffInfoModel>();

  //事業所ID
  agencyId = "";
  //事業所一覧
  agencyList = new Map<string, string>();
  //担当者一覧
  staffList: StaffInfoModel[] = [];
  context: any;
  private gridApi!: GridApi<StaffInfoModel>;
  rowSelection: "single" | "multiple" = "multiple";

  colDefs: ColDef[] = [
    { headerName: '', field: "update", width: 40, cellRenderer: CustomButtonComponent, checkboxSelection: true, headerCheckboxSelection: true },
    { headerName: 'メールアドレス', field: "email", width: 190 },
    { headerName: '氏名', field: "name", width: 160 },
    { headerName: '会社', field: "company", width: 160 },
    { headerName: '部署', field: "department", width: 160 },
    { headerName: '権限', field: "roleName", width: 140 },
    { field: "agencyId", hide: true },
    { field: "password", hide: true },
    { field: "roleId", hide: true }
  ];

  public autoSizeStrategy:
    | SizeColumnsToFitGridStrategy
    | SizeColumnsToFitProvidedWidthStrategy
    | SizeColumnsToContentStrategy = {
      type: "fitGridWidth",
      defaultMinWidth: 100,
      columnLimits: [
        {
          colId: "country",
          minWidth: 900,
        },
      ],
    };

  /**
   * コンストラクタ
   */
  constructor() {
    this.context = {
      componentParent: this
    }
  }

  /**
   * 初期処理
   */
  ngOnInit(): void {
    this.agencyList = new Map();
    for (let i = 0; i < 5; i++) {
      const str = String(i + 1);
      this.agencyList.set("000" + str, "事業所" + str);
      if (i == 0) {
        this.agencyId = "000" + str;
      }
    }
  }

  /**
   * 検索
   */
  onClickSearch(): void {
    //担当者一覧取得
    this.staffList = [];
    for (let i = 0; i < 5; i++) {
      const model = new StaffInfoModel();
      model.agencyId = String(i + 1);
      model.email = "test" + String(i + 1) + "@test.com";
      model.name = "山田 太郎";
      model.password = "00000000";
      model.company = "テスト会社";
      model.department = "テスト部";
      model.roleId = "1";
      model.roleName = "システム管理者";
      this.staffList.push(model);
    }
  }

  /**
   * 新規
   */
  onClickNew(): void {
    this.clickNew.emit();
  }

  /**
   * 編集
   */
  onClickEdit(data: StaffInfoModel): void {
    this.clickEdit.emit(data);
  }

  /**
   * 削除
   */
  onClickDel(): void {
    const list: StaffInfoModel[] = this.gridApi.getSelectedRows();
    const array = [];
    for (const staff of this.staffList) {
      let del = false;
      for (const model of list) {
        if (model.email === staff.email) {
          del = true;
          break;
        }
      }
      if (!del) {
        array.push(staff);
      }
    }
    this.staffList = array;

    this.gridApi.setGridOption("rowData", this.staffList);
  }

  onGridReady(params: any): void {
    this.gridApi = params.api;
  }
}
