import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { StaffInfoModel } from '../../model/staff-info.model';

@Component({
  selector: 'app-staff-regist',
  templateUrl: './staff-regist.component.html',
  styleUrl: './staff-regist.component.css'
})
export class StaffRegistComponent implements OnInit {
  @Input() mode = 0;
  @Input() staffInfoModel?: StaffInfoModel;
  @Output() clickBack: EventEmitter<void> = new EventEmitter<void>();

  //事業所ID
  agencyId?: string;
  //事業所一覧
  agencyList?: Map<string, string>
  //メールアドレス
  email?: string;
  //パスワード
  password?: string;
  //氏名
  name?: string;
  //部署
  department?: string;
  //権限
  roleId?: string;
  //権限一覧
  roleList?: Map<string, string>

  /**
   * コンストラクタ
   */
  constructor() { }

  /**
   * 初期処理
   */
  ngOnInit(): void {
    //事業所一覧
    this.agencyList = new Map();
    for (let i = 0; i < 5; i++) {
      const str = String(i + 1);
      this.agencyList?.set(str, "事業所" + str)
    }
    //権限一覧
    this.roleList = new Map();
    for (let i = 0; i < 3; i++) {
      const str = String(i + 1);
      this.roleList?.set(str, "権限" + str)
    }

    if (this.staffInfoModel !== null) {
      this.agencyId = this.staffInfoModel?.agencyId;
      this.email = this.staffInfoModel?.email;
      this.password = this.staffInfoModel?.password;
      this.name = this.staffInfoModel?.name;
      this.department = this.staffInfoModel?.department;
      this.roleId = this.staffInfoModel?.roleId;
    }
  }

  /**
   * 登録
   */
  onClickRegist(): void {
    //担当者登録

    this.clickBack.emit();
  }

  /**
   * 更新
   */
  onClickUpdate(): void {
    //担当者更新
    this.clickBack.emit();
  }

  /**
   * 戻る
   */
  onClickBack(): void {
    this.clickBack.emit();
  }
}
