import { Component, EventEmitter, Output } from '@angular/core';
import { UserInfoModel } from '../../model/user-info.model';
import { ColDef, GridApi } from 'ag-grid-community';
import { HistoryButtonComponent } from './history-button/history-button.component';
import { DenylistButtonComponent } from './denylist-button/denylist-button.component';
import { SizeColumnsToFitGridStrategy, SizeColumnsToFitProvidedWidthStrategy, SizeColumnsToContentStrategy } from 'ag-grid-community'
import { PassRefundService } from '../../service/pass-refund.service';

/**
 * 利用者検索画面
 */
@Component({
  selector: 'app-user-list',
  templateUrl: './user-list.component.html',
  styleUrl: './user-list.component.css'
})
export class UserListComponent {
  @Output() clickPass: EventEmitter<UserInfoModel> = new EventEmitter<UserInfoModel>();
  @Output() clickHistory: EventEmitter<UserInfoModel> = new EventEmitter<UserInfoModel>();
  @Output() clickDenyList: EventEmitter<UserInfoModel> = new EventEmitter<UserInfoModel>();

  //利用者名
  userName?: string;
  //利用者一覧
  userList: UserInfoModel[] = [];
  context: any;
  private gridApi!: GridApi<UserInfoModel>;

  colDefs: ColDef[] = [
    { headerName: '氏名', field: "name", width: 200 },
    { headerName: 'フリガナ', field: "nameKana", width: 200 },
    { headerName: 'メールアドレス', field: "email", width: 200 },
    { headerName: '電話番号', field: "phoneNumber", width: 200 },
    //{ headerName: '', field: "pass", width: 80, cellRenderer: PassButtonComponent },
    { headerName: '', field: "history", width: 80, cellRenderer: HistoryButtonComponent },
    { headerName: '', field: "denyList", width: 80, cellRenderer: DenylistButtonComponent },
  ];
  public autoSizeStrategy:
    | SizeColumnsToFitGridStrategy
    | SizeColumnsToFitProvidedWidthStrategy
    | SizeColumnsToContentStrategy = {
      type: "fitGridWidth",
      defaultMinWidth: 100,
      columnLimits: [
        {
          colId: "country",
          minWidth: 900,
        },
      ],
    };


  /**
   * コンストラクタ
   */
  constructor(private passRefundService: PassRefundService) {
    this.context = {
      componentParent: this
    }
  }

  /**
   * 検索
   */
  onClickSearch(): void {
    this.userList = [];
    for (let i = 0; i < 10; i++) {
      const str = String(i + 1);
      const model = new UserInfoModel();
      model.name = "山田太郎" + str;
      model.nameKana = "ヤマダタロウ" + str;
      model.email = "tarou_yamada" + str + "@test.com";
      model.phoneNumber = "09088882456";
      this.userList.push(model);
    }
  }

  onGridReady(params: any): void {
    this.gridApi = params.api;
  }

  /**
   * 定期券クリック
   * @param model 利用者情報
   */
  onClickPass(model: UserInfoModel): void {
    this.clickPass.emit(model);
  }

  /**
   * 乗車履歴クリック
   * @param model  利用者情報
   */
  onClickHistory(model: UserInfoModel): void {
    this.clickHistory.emit(model);
  }

  /**
   * 拒否リストクリック
   * @param model 利用者情報
   */
  onClickDenyList(model: UserInfoModel): void {
    this.clickDenyList.emit(model);
  }
}
