import { Component } from '@angular/core';
import { ICellRendererParams } from 'ag-grid-community';

/**
 * 乗車日時
 */
@Component({
  selector: 'app-geton-datetime',
  templateUrl: './geton-datetime.component.html',
  styleUrl: './geton-datetime.component.css'
})
export class GetonDatetimeComponent {
  //パラメータ
  params: any;

  //年
  year?: string;
  //月
  month?: string;
  //日
  day?: string;
  //時
  hour?: string;
  //分
  minute?: string;
  //秒
  second?: string;

  /**
   * 初期処理
   * @param params パラメータ
   */
  agInit(params: ICellRendererParams): void {
    console.log(params);
    this.params = params;
    if (params.data.processDateTime) {
      const dt: string = params.data.processDateTime;
      this.year = dt.substring(0, 4);
      this.month = dt.substring(4, 6);
      this.day = dt.substring(6, 8);
      this.hour = dt.substring(8, 10);
      this.minute = dt.substring(10, 12);
      this.second = dt.substring(12);
    }
  }

  /**
   * リフレッシュ
   * @param params パラメータ 
   * @returns 正常かどうか
   */
  refresh(params: ICellRendererParams) {
    return true;
  }
}
