import { Component, OnInit } from '@angular/core';
import { NgbActiveModal } from '@ng-bootstrap/ng-bootstrap';
import { HistoryModel } from '../../../model/history.model';

/**
 * ステータス更新
 */
@Component({
  selector: 'app-status-update',
  templateUrl: './status-update.component.html',
  styleUrl: './status-update.component.css'
})
export class StatusUpdateComponent implements OnInit {
  //乗降履歴
  model?: HistoryModel;
  //ステータス
  status?: string;

  /**
   * コンストラクタ
   * @param activeModal モーダル
   */
  constructor(private activeModal: NgbActiveModal) { }

  /**
   * 初期処理
   */
  ngOnInit(): void {
    this.status = "0";
  }

  /**
   * 閉じる
   */
  onClickClose(): void {
    this.activeModal.dismiss();
  }

  /**
   * 更新
   */
  onClickUpdate(): void {
    this.activeModal.close();
  }
}
