import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { StaffInfoModel } from '../../model/staff-info.model';
import { StaffService } from '../../service/staff.service';

/**
 * 担当者登録
 */
@Component({
  selector: 'app-staff-regist',
  templateUrl: './staff-regist.component.html',
  styleUrl: './staff-regist.component.css'
})
export class StaffRegistComponent implements OnInit {
  //0:登録、1：更新
  @Input() mode = 0;
  //担当者情報
  @Input() staffInfoModel?: StaffInfoModel;
  @Output() clickBack: EventEmitter<void> = new EventEmitter<void>();

  //事業所ID
  agencyId?: string;
  //事業所一覧
  agencyList?: Map<string, string>
  //メールアドレス
  email?: string;
  //パスワード
  password?: string;
  //氏名
  name?: string;
  //部署
  department?: string;
  //権限
  roleId?: string;
  //権限一覧
  roleList?: Map<string, string>

  /**
   * コンストラクタ
   * @param staffService 担当者サービス
   */
  constructor(private staffService: StaffService) { }

  /**
   * 初期処理
   */
  ngOnInit(): void {
    //事業所一覧
    //this.agencyList = this.staffService.getAgencyList();
    this.staffService.getAgencyList().subscribe((ret: Map<string, string>) => {
      this.agencyList = ret;
    });

    //権限一覧
    //this.roleList = this.staffService.getRoleList();
    this.staffService.getRoleList().subscribe((ret: Map<string, string>) => {
      this.roleList = ret;
    });

    if (this.staffInfoModel !== null) {
      this.agencyId = this.staffInfoModel?.agencyId;
      this.email = this.staffInfoModel?.email;
      this.password = this.staffInfoModel?.password;
      this.name = this.staffInfoModel?.name;
      this.department = this.staffInfoModel?.department;
      this.roleId = this.staffInfoModel?.roleId;
    }
  }

  /**
   * 登録
   */
  onClickRegist(): void {
    //担当者登録
    const staffInfoModel = new StaffInfoModel();
    staffInfoModel.email = this.email;
    staffInfoModel.password = this.password;
    staffInfoModel.name = this.name;
    staffInfoModel.department = this.department;
    staffInfoModel.roleId = this.roleId;
    staffInfoModel.agencyId = this.agencyId;
    this.staffService.regist(staffInfoModel);

    this.clickBack.emit();
  }

  /**
   * 更新
   */
  onClickUpdate(): void {
    //担当者更新
    const staffInfoModel = new StaffInfoModel();
    staffInfoModel.email = this.email;
    staffInfoModel.password = this.password;
    staffInfoModel.name = this.name;
    staffInfoModel.department = this.department;
    staffInfoModel.roleId = this.roleId;
    staffInfoModel.agencyId = this.agencyId;
    this.staffService.update(staffInfoModel);
    this.clickBack.emit();
  }

  /**
   * 戻る
   */
  onClickBack(): void {
    this.clickBack.emit();
  }
}
