import { Injectable } from '@angular/core';
import { PassModel } from '../model/pass.model';
import { Observable } from 'rxjs';

/**
 * 定期券サービス
 */
@Injectable({
  providedIn: 'root'
})
export class PassService {
  /**
   * 定期券一覧取得
   * @param customerId 利用者ID
   * @returns 定期券一覧
   */
  getList(customerId: string): Observable<PassModel[]> {
    //TODO
    const passList: PassModel[] = [];
    if (customerId) {
      for (let i = 0; i < 3; i++) {
        const model: PassModel = new PassModel();
        const str = String(i + 1);
        model.id = str;
        model.routeName = "【○○○系統】XXXXXX→XXXXXX行き";
        model.startDate = "2024/07/01";
        model.useTerm = "3ヶ月";
        model.priceRange = "大人";
        model.rideSection = "A停留所～B停留所";
        model.getonStopName = "A停留所";
        model.getoffStopName = "B停留所";
        model.creditCardNumber = "**** **** **** 1234";
        passList.push(model);
      }
    }
    //return passList;
    return new Observable<PassModel[]>(o => {
      o.next(passList);
    });
  }

  /**
   * 定期券払戻
   * @param model 定期券情報
   */
  refund(model: PassModel): void {
    //TODo
    if (model) {
      return;
    }
  }
}
