import { NgModule } from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { AppRoutingModule } from './app-routing.module';
import { AppComponent } from './app.component';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { jqxGridModule } from 'jqwidgets-ng/jqxgrid';
import { CommonModule } from '@angular/common';
import { CdkListbox, CdkOption } from '@angular/cdk/listbox';

import { TopComponent } from './top/top.component';
import { HeaderComponent } from './header/header.component';
import { MenuComponent } from './menu/menu.component';
import { provideAnimationsAsync } from '@angular/platform-browser/animations/async';
import { StaffListComponent } from './menu/staff-list/staff-list.component';
import { UserListComponent } from './menu/user-list/user-list.component';
import { RoleMstComponent } from './menu/master/role-mst/role-mst.component';
import { PassFareComponent } from './menu/master/pass-fare/pass-fare.component';
import { StaffRegistComponent } from './menu/staff-regist/staff-regist.component'
@NgModule({
  declarations: [
    AppComponent,
    TopComponent,
    HeaderComponent,
    MenuComponent,
    StaffListComponent,
    UserListComponent,
    RoleMstComponent,
    PassFareComponent,
    StaffRegistComponent
  ],
  imports: [
    BrowserModule,
    AppRoutingModule,
    NgbModule,
    FormsModule,
    jqxGridModule,
    CommonModule,
    CdkListbox,
    CdkOption,
    ReactiveFormsModule
  ],
  providers: [
    provideAnimationsAsync()
  ],
  bootstrap: [AppComponent]
})
export class AppModule { }
