import { FlatTreeControl } from '@angular/cdk/tree';
import { Component } from '@angular/core';

interface ExampleFlatNode {
  expandable: boolean;
  name: string;
  level: number;
}

@Component({
  selector: 'app-menu',
  templateUrl: './menu.component.html',
  styleUrl: './menu.component.css'
})
export class MenuComponent {
  //モード(0:事業所担当者、1:利用者検索、2:利用者登録・更新、3:権限マスタ、4:定期券運賃マスタ)
  mode: number = 0;

  //担当者編集モード(0:登録、1:編集)
  staffEditMode: number = 0;

  /**
   * 事業所担当者
   */
  onClickBusiness(): void {
    this.mode = 0;
  }

  /**
   * 利用者検索
   */
  onClickUser(): void {
    this.mode = 1;
  }

  /**
   * 新規
   */
  onClickNew(): void {
    this.mode = 2;
  }

  /**
   * 編集
   * @param row 行番号
   */
  onClickEdit(row: number): void {
    this.mode = 2;
  }

  /**
   * 担当者登録後
   */
  onClickRegist(): void {
    this.mode = 0;
  }

  /**
   * 権限マスタ
   */
  onClickRoleMst(): void {
    this.mode = 3;
  }

  /**
   * 定期券運賃マスタ
   */
  onClickPassFare(): void {
    this.mode = 4;
  }
}
