import { Component, EventEmitter, OnInit, Output, ViewChild } from '@angular/core';
import { StaffInfoModel } from '../../model/staff-info.model';
import { jqxGridComponent } from 'jqwidgets-ng/jqxgrid';

/**
 * 事業所担当者一覧
 */
@Component({
  selector: 'app-staff-list',
  templateUrl: './staff-list.component.html',
  styleUrl: './staff-list.component.css'
})
export class StaffListComponent implements OnInit {
  @Output() clickNew: EventEmitter<void> = new EventEmitter();
  @Output() clickEdit: EventEmitter<number> = new EventEmitter();
  @ViewChild('grid', { static: false }) myGrid?: jqxGridComponent;
  //事業所ID
  agencyId: string = "";
  //事業所一覧
  agencyList: Map<string, string> = new Map();
  //担当者一覧
  staffList: StaffInfoModel[] = [];

  source: any = {
    datatype: 'json',
    datafields: [
      { name: 'update', type: 'string' },
      { name: 'email', type: 'string' },
      { name: 'name', type: 'string' },
      { name: 'company', type: 'string' },
      { name: 'department', type: 'string' },
      { name: 'roleName', type: 'string' }
    ]
  }
  columns = [
    {
      text: '', datafield: 'update', width: 40, cellsrenderer: function (row: any, column: any, value: any) {
        return '<input type="button" style="width:40px;height:100%;" data-row="' + row + '" onclick="onClickEdit(' + row + ')" value="編集">';
      }
    },
    { text: 'メールアドレス', datafield: 'email', width: 200, },
    { text: '氏名', datafield: 'name', width: 200 },
    { text: '会社', datafield: 'company', width: 100 },
    { text: '部署', datafield: 'department', width: 100 },
    { text: '権限', datafield: 'roleName', width: 100 }
  ];

  /**
   * コンストラクタ
   */
  constructor() { }

  /**
   * 初期処理
   */
  ngOnInit(): void {
    this.agencyList = new Map();
    for (let i = 0; i < 5; i++) {
      let str = String(i + 1);
      this.agencyList.set("000" + str, "事業所" + str);
      if (i == 0) {
        this.agencyId = "000" + str;
      }
    }
  }

  /**
   * 検索
   */
  onClickSearch(): void {
    //担当者一覧取得
    this.staffList = new Array();
    for (let i = 0; i < 5; i++) {
      let model = new StaffInfoModel();
      model.email = "test" + String(i + 1) + "@test.com";
      model.name = "山田 太郎";
      model.company = "テスト会社";
      model.department = "テスト部";
      model.roleId = "0";
      model.roleName = "システム管理者";
      this.staffList.push(model);
    }

    this.source.localdata = JSON.stringify(this.staffList);
    this.myGrid?.updatebounddata();
  }

  /**
   * 新規
   */
  onClickNew(): void {
    this.clickNew.emit();
  }

  /**
   * 編集
   */
  onClickEdit(row: number): void {
    this.clickEdit.emit(row);
  }

  /**
   * 削除
   */
  onClickDel(): void {
    //TODO
    if (typeof this.myGrid !== "undefined") {
      let rows = this.myGrid.getselectedrowindexes();
      for (let i = 0; i < rows.length; i++) {
        console.log(rows[i]);
      }
    }
  }
}
