import { Component, ViewChild } from '@angular/core';
import { UserInfoModel } from '../../model/user-info.model';
import { jqxGridComponent } from 'jqwidgets-ng/jqxgrid';

/**
 * 利用者検索画面
 */
@Component({
  selector: 'app-user-list',
  templateUrl: './user-list.component.html',
  styleUrl: './user-list.component.css'
})
export class UserListComponent {
  @ViewChild('grid', { static: false }) myGrid?: jqxGridComponent;
  //利用者名
  userName?: string;
  //利用者一覧
  userList: UserInfoModel[] = [];

  source: any = {
    datatype: 'json',
    datafields: [
      { name: 'name', type: 'string' },
      { name: 'nameKana', type: 'string' },
      { name: 'email', type: 'string' },
      { name: 'phoneNumber', type: 'string' },
      { name: 'pass', type: 'string' },
      { name: 'history', type: 'string' },
      { name: 'denyList', type: 'string' }
    ]
  }
  columns = [
    { text: '氏名', datafield: 'name', width: 200, },
    { text: 'フリガナ', datafield: 'nameKana', width: 200 },
    { text: 'メールアドレス', datafield: 'email', width: 200 },
    { text: '電話番号', datafield: 'phoneNumber', width: 100 },
    {
      text: '', datafield: 'pass', width: 80, cellsrenderer: function (row: any, column: any, value: any) {
        return '<input type="button" style="width:80px;height:100%;" data-row="' + row + '" onclick="onClickPass(' + row + ')" value="定期券">';
      }
    },
    {
      text: '', datafield: 'history', width: 80, cellsrenderer: function (row: any, column: any, value: any) {
        return '<input type="button" style="width:80px;height:100%;" data-row="' + row + '" onclick="onClickHistory(' + row + ')" value="乗降履歴">';
      }
    },
    {
      text: '', datafield: 'denyList', width: 80, cellsrenderer: function (row: any, column: any, value: any) {
        return '<input type="button" style="width:80px;height:100%;" data-row="' + row + '" onclick="onClickHistory(' + row + ')" value="拒否リスト">';
      }
    }
  ];

  /**
   * コンストラクタ
   */
  constructor() { }

  /**
   * 検索
   */
  onClickSearch(): void {
    this.userList = new Array();
    for (let i = 0; i < 10; i++) {
      let str = String(i + 1);
      let model = new UserInfoModel();
      model.name = "山田太郎" + str;
      model.nameKana = "ヤマダタロウ" + str;
      model.email = "tarou_yamada" + str + "@test.com";
      model.phoneNumber = "09088882456";
      this.userList.push(model);
    }

    this.source.localdata = JSON.stringify(this.userList);
    this.myGrid?.updatebounddata();
  }
}
