import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';

@Component({
  selector: 'app-staff-regist',
  templateUrl: './staff-regist.component.html',
  styleUrl: './staff-regist.component.css'
})
export class StaffRegistComponent implements OnInit {
  @Input() mode: number = 0;
  @Output() clickBack: EventEmitter<void> = new EventEmitter();
  //事業所ID
  agencyId?: string;
  //事業所一覧
  agencyList?: Map<string, string>
  //メールアドレス
  email?: string;
  //パスワード
  password?: string;
  //氏名
  name?: string;
  //部署
  department?: string;
  //権限
  roleId?: string;
  //権限一覧
  roleList?: Map<string, string>

  /**
   * コンストラクタ
   */
  constructor() { }

  /**
   * 初期処理
   */
  ngOnInit(): void {
    //事業所一覧
    this.agencyList = new Map();
    for (let i = 0; i < 5; i++) {
      let str = String(i + 1);
      this.agencyList?.set(str, "事業所" + str)
    }
    //権限一覧
    this.roleList = new Map();
    for (let i = 0; i < 3; i++) {
      let str = String(i + 1);
      this.roleList?.set(str, "権限" + str)
    }
  }

  /**
   * 登録
   */
  onClickRegist(): void {
    //担当者登録

    this.clickBack.emit();
  }

  /**
   * 更新
   */
  onClickUpdate(): void {
    //担当者更新
    this.clickBack.emit();
  }

  /**
   * 戻る
   */
  onClickBack(): void {
    this.clickBack.emit();
  }
}
