import { Component, OnInit } from '@angular/core';
import { RouteService } from '../services/route.service';
import { CommuterPassModel } from '../model/commuter-pass.model';
import { PassService } from '../services/pass.service';

/**
 * 定期券登録画面
 */
@Component({
  selector: 'app-pass-regist',
  templateUrl: './pass-regist.page.html',
  styleUrls: ['./pass-regist.page.scss'],
})
export class PassRegistPage implements OnInit {
  public confirmButtons = [
    {
      text: 'いいえ',
      role: 'cancel'
    },
    {
      text: 'はい',
      role: 'confirm'
    },
  ];


  //路線一覧
  routeList?: Map<string, string>;
  //使用期間一覧
  useTermList?: Map<string, string>;
  //料金区分一覧
  priceRangeList?: Map<string, string>;
  //停留所一覧
  stopList?: Map<string, string>;

  //路線
  routeId?: string;
  //使用期間
  useTermId?: string;
  //料金区分
  priceRangeId?: string;
  //使用開始日
  startDate?: string;
  //乗車停留所
  getonStopId?: string;
  //区間
  getoffStopId?: string;
  //支払金額
  price: number = 0;
  //事業者ID
  agencyId: string = "";

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   * @param passService 定期券サービス
   */
  constructor(private routeService: RouteService, private passService: PassService) { }

  /**
   * 初期化
   */
  ngOnInit(): void {

    //路線一覧
    //TODO 事業者IDはどうやって決める?
    this.routeList = this.passService.getRouteList(this.agencyId);
    this.routeId = this.routeList.keys().next().value;

    //使用期間一覧
    this.useTermList = this.passService.getUseTermList(this.agencyId);
    this.useTermId = this.useTermList.keys().next().value;

    //料金区分一覧
    this.priceRangeList = this.passService.getPriceRangeList(this.agencyId);
    this.priceRangeId = this.priceRangeList.keys().next().value;

    //停留所一覧
    this.stopList = this.passService.getStopList(this.agencyId, this.routeList.values().next().value);
    this.getonStopId = this.stopList.keys().next().value;
    this.getoffStopId = this.stopList.keys().next().value;
  }

  /**
   * 路線選択
   * @param event イベント情報
   */
  onChangeRoute(event: any): void {
    this.stopList = this.passService.getStopList(this.agencyId, event.target.value);
    this.price = this.passService.calcPassAmount(this.agencyId, event.target.value, this.useTermId, this.priceRangeId, this.getonStopId, this.getoffStopId);
  }

  /**
   * 使用期間選択
   * @param event イベント情報 
   */
  onChangeTerm(event: any): void {
    this.price = this.passService.calcPassAmount(this.agencyId, this.routeId, event.target.value, this.priceRangeId, this.getonStopId, this.getoffStopId);
  }

  /**
   * 料金区分選択
   * @param event イベント情報 
   */
  onChangeRange(event: any): void {
    this.price = this.passService.calcPassAmount(this.agencyId, this.routeId, this.useTermId, event.target.value, this.getonStopId, this.getoffStopId);
  }

  /**
   * 乗車停留所選択
   * @param event イベント情報
   */
  onChangeGetOn(event: any): void {
    this.price = this.passService.calcPassAmount(this.agencyId, this.routeId, this.useTermId, this.priceRangeId, event.target.value, this.getoffStopId);
  }

  /**
   * 降車停留所選択
   * @param event イベント情報
   */
  onChangeGetOff(event: any): void {
    this.price = this.passService.calcPassAmount(this.agencyId, this.routeId, this.useTermId, this.priceRangeId, this.getonStopId, event.target.value);
  }

  /**
   * 閉じる
   */
  onClickClose(): void {
    this.routeService.navigatePassSelect(this.routeService.cardNumber);
  }

  /**
   * 追加
   */
  onClickAdd(event: any): void {
    if (event.detail.role === 'confirm') {
      //定期券登録
      let model: CommuterPassModel = new CommuterPassModel();
      model.tokenId = this.routeService.tokenId;
      model.routeId = this.routeId ? this.routeId : "";
      model.startDate = this.startDate ? this.startDate : "";
      model.useTermId = this.useTermId ? this.useTermId : "";
      model.priceRangeId = this.priceRangeId ? this.priceRangeId : "";
      model.getonStopId = this.getonStopId ? this.getonStopId : "";
      model.getoffStopId = this.getoffStopId ? this.getoffStopId : "";
      this.passService.regist(model);
    }
    this.routeService.navigatePassSelect(this.routeService.cardNumber);
  }
}
