import { Component, OnInit } from '@angular/core';
import { CommuterPassModel } from '../model/commuter-pass.model';
import { RouteService } from '../services/route.service';
import { PassService } from '../services/pass.service';

/**
 * 定期券選択画面
 */
@Component({
  selector: 'app-pass-select',
  templateUrl: './pass-select.page.html',
  styleUrls: ['./pass-select.page.scss'],
})
export class PassSelectPage implements OnInit {
  //カード番号
  cardNumber?: string;
  //定期券情報
  commuterPassList?: CommuterPassModel[];

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   * @param passServiec 定期券サービス
   */
  constructor(private routeService: RouteService, private passService: PassService) {
    this.cardNumber = routeService.cardNumber;
  }

  /**
   * 初期化
   */
  ngOnInit() {
    if (this.routeService.tokenId) {
      this.commuterPassList = this.passService.getList(this.routeService.tokenId);
    }
  }

  /**
   * 戻る
   */
  onClickBack(): void {
    this.routeService.navigateCardSelect();
  }

  /**
   * 定期券区間変更
   * @param model 定期券情報
   */
  onClickChange(model: CommuterPassModel) {
    this.routeService.navigatePassChange(model);
  }

  /**
   * 定期券継続
   * @param model 定期券情報
   */
  onClickContinue(model: CommuterPassModel) {
    this.routeService.navigatePassContinue(model);
  }

  /**
   * 定期券払戻
   * @param model 定期券情報
   */
  onClickRefund(model: CommuterPassModel) {
    this.routeService.navigatePassRefund(model);
  }

  /**
   * 定期券登録
   */
  onClickAddPass() {
    this.routeService.navigatePassRegist();
  }
}
