import { NgModule } from '@angular/core';
import { PreloadAllModules, RouterModule, Routes } from '@angular/router';

const routes: Routes = [
  {
    path: 'home',
    loadChildren: () => import('./home/home.module').then(m => m.HomePageModule)
  },
  {
    path: '',
    redirectTo: 'home',
    pathMatch: 'full'
  },
  {
    path: 'card-select',
    loadChildren: () => import('./card-select/card-select.module').then(m => m.CardSelectPageModule)
  },
  {
    path: 'card-regist',
    loadChildren: () => import('./card-regist/card-regist.module').then(m => m.CardRegistPageModule)
  },
  {
    path: 'pass-select',
    loadChildren: () => import('./pass-select/pass-select.module').then(m => m.PassSelectPageModule)
  },
  {
    path: 'pass-regist',
    loadChildren: () => import('./pass-regist/pass-regist.module').then(m => m.PassRegistPageModule)
  },
  {
    path: 'claim-list',
    loadChildren: () => import('./claim-list/claim-list.module').then(m => m.ClaimListPageModule)
  },
];

@NgModule({
  imports: [
    RouterModule.forRoot(routes, { preloadingStrategy: PreloadAllModules })
  ],
  exports: [RouterModule]
})
export class AppRoutingModule { }
