import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { IonicModule } from '@ionic/angular';
import { CreditCardModel } from 'src/app/model/credit-card.model';

/**
 * カード情報
 */
@Component({
  standalone: true,
  selector: 'app-card-info',
  templateUrl: './card-info.component.html',
  styleUrls: ['./card-info.component.scss'],
  imports: [
    IonicModule
  ]
})
export class CardInfoComponent implements OnInit {
  //クレジットカード情報
  @Input() creditCardModel?: CreditCardModel;
  @Output() clickDenyStatus: EventEmitter<void> = new EventEmitter();
  @Output() clickTrash: EventEmitter<void> = new EventEmitter();

  public confirmButtons = [
    {
      text: 'いいえ',
      role: 'cancel'
    },
    {
      text: 'はい',
      role: 'confirm'
    },
  ];

  denyStatusId?: string;
  deleteDenyId?: string;
  deleteCardId?: string;

  /**
   * コンストラクタ
   */
  constructor() { }

  ngOnInit(): void {
    this.denyStatusId = "denuStatus" + this.creditCardModel?.cardNumber;
    this.deleteDenyId = "deleteDeny" + this.creditCardModel?.cardNumber;
    this.deleteCardId = "deleteCard" + this.creditCardModel?.cardNumber;
  }

  /**
   * 拒否リスト状態
   */
  onClickDenyStatus(event: any): void {
    if (event.detail.role === 'confirm') {
      this.clickDenyStatus.emit();
    }
  }

  /**
   * 削除
   */
  onClickTrash(event: any): void {
    this.clickTrash.emit();
  }
}
