import { Component, OnInit } from '@angular/core';
import { RouteService } from '../services/route.service';
import { CreditCardModel } from '../model/credit-card.model';
import { CardService } from '../services/card.service';

/**
 * クレジットカード選択
 */
@Component({
  selector: 'app-card-select',
  templateUrl: './card-select.page.html',
  styleUrls: ['./card-select.page.scss'],
})
export class CardSelectPage implements OnInit {
  cardList?: CreditCardModel[];

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   * @param cardService クレジットカードサービス
   */
  constructor(private routeService: RouteService, private cardService: CardService) { }

  /**
   * 初期化
   */
  ngOnInit(): void {
    //this.cardList = this.cardService.getList(this.routeService.customerId);
    this.cardService.getList(this.routeService.customerId).subscribe((ret: CreditCardModel[]) => {
      this.cardList = ret;
    });
  }

  /**
   * 戻る
   */
  onClickBack(): void {
    this.routeService.navigateHome();
  }

  /**
   * クレジットカード追加
   */
  onClickAddCard(): void {
    this.routeService.navigateCardRegist();
  }

  /**
   * 拒否リスト状態
   * @param model クレジットカード情報
   */
  onClickDenyStatus(model: CreditCardModel): void {
    if (this.cardList) {
      for (let i = 0; i < this.cardList?.length; i++) {
        if (this.cardList[i].tokenId === model.tokenId && this.cardList[i].denyStatus == 1) {
          this.cardList[i].deleteDeny = this.cardList[i].deleteDeny == 0 ? 1 : 0;
        }
      }
    }
  }

  /**
   * 削除
   * @param model クレジットカード情報
   */
  onClickTrash(model: CreditCardModel): void {
    this.cardService.delete(model.tokenId);
  }
}
