import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { IonicModule } from '@ionic/angular';
import { ClaimListModel } from 'src/app/model/claim-list.model';
import { CustomDatePipe } from 'src/app/pipe/custom-date.pipe';
import { CustomDatetimePipe } from 'src/app/pipe/custom-datetime.pipe';
import { DecimalPipe } from '@angular/common';

/**
 * 請求一覧情報
 */
@Component({
  standalone: true,
  selector: 'app-claim-info',
  templateUrl: './claim-info.component.html',
  styleUrls: ['./claim-info.component.scss'],
  imports: [
    IonicModule,
    CustomDatePipe,
    CustomDatetimePipe,
    DecimalPipe
  ]
})
export class ClaimInfoComponent implements OnInit {
  @Input() model: ClaimListModel = new ClaimListModel();
  @Output() clickPayReq: EventEmitter<ClaimListModel> = new EventEmitter<ClaimListModel>();

  public confirmButtons = [
    {
      text: 'いいえ',
      role: 'cancel'
    },
    {
      text: 'はい',
      role: 'confirm'
    },
  ];

  //支払要求メッセージダイアログ表示有無
  isPayOpen: boolean = false;

  /**
   * コンストラクタ
   */
  constructor() { }

  /**
   * 初期化
   */
  ngOnInit(): void {
  }

  /**
   * 請求情報取得
   * @returns 請求情報
   */
  getModel(): ClaimListModel {
    return this.model;
  }

  /**
   * 支払要求ダイアログを表示する前の処理
   */
  onClickBefPayReq(): void {
    this.isPayOpen = true;
  }

  /**
   * 支払要求ダイアログ
   * @param event 
   */
  onClickPayReq(event: any): void {
    if (event.detail.role === 'confirm') {
      this.clickPayReq.emit(this.model);
    }
    this.isPayOpen = false;
  }
}
