import { Component, OnInit } from '@angular/core';
import { RouteService } from '../services/route.service';

/**
 * ログイン画面
 */
@Component({
  selector: 'app-home',
  templateUrl: 'home.page.html',
  styleUrls: ['home.page.scss'],
})
export class HomePage {

  /**
   * コンストラクタ
   * @param routeServive 画面遷移サービス
   */
  constructor(private routeServive: RouteService) { }


  /**
   * ログアウト
   */
  onClickLogout(): void {
    this.routeServive.navigateHome();
  }

  /**
   * クレジットカード選択
   */
  onClickCardSelect(): void {
    this.routeServive.navigateCardSelect();
  }

  /**
   * 請求一覧
   */
  onClickClaimList(): void {
    this.routeServive.navigateClaimList();
  }
}
