import { Component, OnInit } from '@angular/core';
import { RouteService } from '../services/route.service';
import { CommuterPassModel } from '../model/commuter-pass.model';
import { PassService } from '../services/pass.service';

/**
 * 定期券登録画面
 */
@Component({
  selector: 'app-pass-regist',
  templateUrl: './pass-regist.page.html',
  styleUrls: ['./pass-regist.page.scss'],
})
export class PassRegistPage implements OnInit {
  //定期券一覧
  commuterPassList?: CommuterPassModel[];

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   * @param passService 定期券サービス
   */
  constructor(private routeService: RouteService, private passService: PassService) { }

  /**
   * 初期化
   */
  ngOnInit(): void {
    this.passService.getListNoCard().subscribe((ret: CommuterPassModel[]) => {
      this.commuterPassList = ret;
    });

  }

  /**
    * 閉じる
    */
  onClickClose(): void {
    this.routeService.navigatePassSelect(this.routeService.cardNumber);
  }

  /**
   * 追加
   * @param event イベント情報
   */
  onClickAdd(event: any): void {
    this.routeService.navigatePassSelect(this.routeService.cardNumber);
  }
}
