import { Injectable } from '@angular/core';
import { CreditCardModel } from '../model/credit-card.model';
import { Observable } from 'rxjs';
import { HttpClient } from '@angular/common/http';

/**
 * クレジットカードサービス
 */
@Injectable({
  providedIn: 'root'
})
export class CardService {
  readonly cardUrl = './data/card.json';

  /**
   * コンストラクタ
   */
  constructor(private http: HttpClient) { }

  /**
   * クレジットカード情報一覧取得
   * @param customerId 利用者ID
   */
  getList(customerId?: string): Observable<CreditCardModel[]> {
    return this.http.get<CreditCardModel[]>(this.cardUrl);
  }

  /**
   * クレジットカード情報登録
   * @param customerId 利用者ID
   * @param model クレジットカード情報
   */
  regist(customerId?: string, model?: CreditCardModel): void {
    //TODO
  }

  /**
   * クレジットカード情報削除
   * @param tokenId トークンID
   */
  delete(tokenId?: string): void {
    //TODO
  }
}
