import { Injectable } from '@angular/core';
import { CommuterPassModel } from '../model/commuter-pass.model';
import { Observable } from 'rxjs';
import { HttpClient } from '@angular/common/http';

/**
 * 定期券サービス
 */
@Injectable({
  providedIn: 'root'
})
export class PassService {
  readonly passUrl = "./data/pass.json";

  /**
   * コンストラクタ
   */
  constructor(private http: HttpClient) { }

  /**
   * 定期一覧取得
   * @param tokenId トークンID
   * @return 定期一覧
   */
  getList(tokenId: string): Observable<CommuterPassModel[]> {
    //TODO
    return this.http.get<CommuterPassModel[]>(this.passUrl);
  }

  /**
   * 定期一覧取得
   * @return 定期一覧
   */
  getListNoCard(): Observable<CommuterPassModel[]> {
    //TODO
    return this.http.get<CommuterPassModel[]>(this.passUrl);
  }


  /**
   * 定期券登録
   * @param model 定期券情報
   */
  regist(model: CommuterPassModel): void {
    //TODO
  }

}
