import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { IonicModule } from '@ionic/angular';
import { ClaimListModel } from 'src/app/model/claim-list.model';
import { CustomDatePipe } from 'src/app/pipe/custom-date.pipe';
import { CustomDatetimePipe } from 'src/app/pipe/custom-datetime.pipe';
import { DecimalPipe } from '@angular/common';

/**
 * 請求一覧情報
 */
@Component({
  standalone: true,
  selector: 'app-claim-info',
  templateUrl: './claim-info.component.html',
  styleUrls: ['./claim-info.component.scss'],
  imports: [
    IonicModule,
    CustomDatePipe,
    CustomDatetimePipe,
    DecimalPipe
  ]
})
export class ClaimInfoComponent implements OnInit {
  @Input() model: ClaimListModel = new ClaimListModel();
  @Output() clickPayReq: EventEmitter<ClaimListModel> = new EventEmitter<ClaimListModel>();
  @Output() clickCancelReq: EventEmitter<ClaimListModel> = new EventEmitter<ClaimListModel>();

  public confirmButtons = [
    {
      text: 'いいえ',
      role: 'cancel'
    },
    {
      text: 'はい',
      role: 'confirm'
    },
  ];

  //取消依頼メッセージダイアログ表示有無
  isCancelOpen: boolean = false;
  //支払要求メッセージダイアログ表示有無
  isPayOpen: boolean = false;

  /**
   * コンストラクタ
   */
  constructor() { }

  /**
   * 初期化
   */
  ngOnInit(): void {
  }

  /**
   * 拒否リスト情報取得
   * @returns 拒否リスト情報
   */
  getModel(): ClaimListModel {
    return this.model;
  }

  /**
   * 取消依頼ダイアログを表示する前の処理
   */
  onClickBefCancelReq(): void {
    if (this.model.payRequest === 1) {
      //既に支払要求済の場合は取消させない
      alert("既に支払要求済となっています。")
      return;
    }
    this.isCancelOpen = true;
  }

  /**
   * 取消依頼ダイアログ
   * @param event 
   */
  onClickCancelReq(event: any): void {
    if (event.detail.role === 'confirm') {
      this.clickCancelReq.emit(this.model);
    }
    this.isCancelOpen = false;
  }

  /**
   * 支払要求ダイアログを表示する前の処理
   */
  onClickBefPayReq(): void {
    if (this.model.cancelRequest === 1) {
      //既に取消依頼済の場合は支払要求させない
      alert("既に取消依頼済となっています。");
      return;
    }
    this.isPayOpen = true;
  }

  /**
   * 支払要求ダイアログ
   * @param event 
   */
  onClickPayReq(event: any): void {
    if (event.detail.role === 'confirm') {
      this.clickPayReq.emit(this.model);
    }
    this.isPayOpen = false;
  }
}
